/* 
 * fgets-fputs.c 
 *
 * Виводить дані зі стандартного потоку введення у стандартний потік
 * виведення результатів або у заданий файл.
 * Ілюструє порядок застосування функцій fopen(),
 * fgets(), fputs(), setvbuf().
 *
 */

#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

enum { BUFSIZE = 80 };


int main(int argc, char *argv[])
{
        FILE *out;              /* Потік виведення */
        char buf[BUFSIZE];

        if (argc < 2)
                /* Виводити буде у стандартний потік
                   виведення результатів. */
                out = stdout;
        else {
                /* Виводити буде у файл. */
                out = fopen(argv[1], "w");
                if (out == NULL) {
                        fprintf(stderr, "Error opening output"
                                        " stream: %s\n", strerror(errno));
                        exit(EXIT_FAILURE);
                }
                /* Встановлює для потоку out порядкову буферизацію. */
                if (setvbuf(out, NULL, _IOLBF, 0) != 0) {
                        fprintf(stderr, "Error setting line buffering"
                                        " to output stream: %s\n",
                                                        strerror(errno));
                        exit(EXIT_FAILURE);
                }
        }

        while (1) {
                /* Читає рядок зі стандартного потоку введення. */
                if (fgets(buf, BUFSIZE, stdin) == NULL) {
                        if (ferror(stdin)) {
                                fprintf(stderr, "Error reading from"
                                        " stdin: %s\n", strerror(errno));
                                exit(EXIT_FAILURE);
                        }
                        /* Кінець файлу */
                        exit(EXIT_SUCCESS);
                }
                /* Виводить прочитаний рядок. */
                if (fputs(buf, out) == EOF) {
                        fprintf(stderr, "Error writing to output"
                                        " stream: %s\n", strerror(errno));
                        exit(EXIT_FAILURE);
                }
        } 
}
